#include "GLOBAL.H"
#include "MCU.H"
#include "KEYBOARD.H"
#include "SPEAKER.H"
#include "MOUSE.H"
#include "USB.H"
#include "USB_DSC.H"


//-----MCU.C-----//
extern void Reboot_Mcu( BYTE );
extern void Delay_Xms( BYTE );

//-----KEYBOARD.C-----//
extern bdata BYTE LED_STATUS;
extern KEYBOARD KB;
extern void KB_LED_Status( void );
extern void KB_LED_Off( void );
extern void Initial_KB( void );
extern void KB_WakeUp_State( void );
extern void KB_Normal_State( void );

//-----SPK.C-----//
extern idata SPK Spk;
extern void SPK_PLL_Divider( void );
//extern void SPK_Initial_Codec( void );
extern void SPK_VOL_Vol_Ctrl( BYTE , BYTE );
extern void SPK_VOL_Mix_Ctrl( BYTE );
extern void SPK_VOL_Mic_Ctrl( BYTE );
extern void SPK_Power_On( void );
extern void SPK_Power_Off( void );

//-----MOUSE.C-----//
extern MOUSE Mouse;
extern void Initial_MS( void );

EP0INFO Ep0;


void Initial_USB( void )
  { USB[IEN] = CLR;                              // Disable USB all related interrupts
    
    USB[EPINDEX] = EP0;                          // Change to EP0 
    USB[EPCON] = ( TXEPEN | RXEPEN );            // Enable Tx & Rx
    USB[EPCON] |= ( TXSTL | RXSTL );             // Set RXSTL & TXSTL (prevent not SETUP Token)
    USB[TXCON] = TXCLR;                          // Clear Tx FIFO
    USB[RXCON] = RXCLR;                          // Clear Rx FIFO
    
    USB[PFTH] |= BFA;                            // Enable 576 bytes Buffer for Audio function   
    
#ifdef SI_IIS                                    // Serial Interface
    USB[SIFCFG] &= ~PCMI_EN;
  #ifdef IIS_STD                                 // Standar IIS
    USB[SIFCFG] &= ~DFSYC;
  #endif
  #ifdef IIS_LJF                                 // Left Justified
    USB[SIFCFG] |= DFSYC;
  #endif
#endif

#ifdef SI_PCM                                    // Serial Interface
    USB[SIFCFG] |= PCMI_EN;
  #ifdef PCM_SSY                                 // Short Sync
    USB[SIFCFG] &= ~DFSYC;
  #endif
  #ifdef PCM_LSY                                 // Long Sync
    USB[SIFCFG] |= DFSYC;
  #endif
#endif

#ifdef SI_SD16                                   // Serial Interface - Data Length
    USB[SIFCFG] |= SD16EN;
#endif
#ifdef SI_SD32                                   // Serial Interface - Data Length
    USB[SIFCFG] &= ~SD16EN;
#endif


#ifdef SD_PCM16
    USB[SDFCFG] &= ~PCM8EN;
#endif
#ifdef SD_PCM8
    USB[SDFCFG] |= PCM8EN;
#endif

#ifdef SD_MI
    USB[SDFCFG] &= ~AISTERO;
#endif
#ifdef SD_SI
    USB[SDFCFG] |= AISTERO;
#endif

#ifdef SD_MO
    USB[SDFCFG] |= AOMON;
#endif
#ifdef SD_SO
    USB[SDFCFG] &= ~AOMON;
#endif

#ifdef SF_48K
    USB[SDFCFG] |= ASRS2;
    USB[SDFCFG] |= ASRS1;
    USB[SDFCFG] |= ASRS0;
#endif
#ifdef SF_32K
    USB[SDFCFG] &= ~ASRS2;
    USB[SDFCFG] |= ASRS1;
    USB[SDFCFG] |= ASRS0;
#endif
#ifdef SF_24K
    USB[SDFCFG] |= ASRS2;
    USB[SDFCFG] |= ASRS1;
    USB[SDFCFG] &= ~ASRS0;
#endif
#ifdef SF_16K
    USB[SDFCFG] &= ~ASRS2;
    USB[SDFCFG] |= ASRS1;
    USB[SDFCFG] &= ~ASRS0;
#endif
#ifdef SF_12K
    USB[SDFCFG] |= ASRS2;
    USB[SDFCFG] &= ~ASRS1;
    USB[SDFCFG] |= ASRS0;
#endif
#ifdef SF_8K
    USB[SDFCFG] &= ~ASRS2;
    USB[SDFCFG] &= ~ASRS1;
    USB[SDFCFG] |= ASRS0;
#endif
#ifdef SF_44_1K
    USB[SDFCFG] |= ASRS2;
    USB[SDFCFG] &= ~ASRS1;
    USB[SDFCFG] &= ~ASRS0;
#endif
#ifdef SF_22_05K
    USB[SDFCFG] &= ~ASRS2;
    USB[SDFCFG] &= ~ASRS1;
    USB[SDFCFG] &= ~ASRS0;
#endif
                                                 // Enable SIF0 Interface ( H/W pin will be Output )
    USB[SIOCTL] |= ( SIFOE | MCKFD | MCKOE1 | MCKOE0 );
                                                 // 12.288 Mhz
    USB[AFCTL] |= ( AOFEN | MIXEN | AIFEN );     // 
#ifdef PM_LBP
    USB[AFCTL] |= LPBEN;
#endif
    
//    USB[UIE] = ( UTXIE0 | URXIE0 | UTXIE1 | SOFIE | ASOFIE );   
    USB[UIE] = ( UTXIE0 | URXIE0 | UTXIE1 | UTXIE2 );
    
    USB[IEN] = ( EF | EFSR );                    // Enable USB all related interrupts
    
    Ep0.Unit = EP0_MAX;                          // 
    Ep0.EmuOk = CLR;                             // Check Emulation status
    Ep0.RWEN = CLR;                              // Remote/Wakeup flag ( Default " Disable " )
    Ep0.Out_AltSet = SPKALTSET0;
    Ep0.In_AltSet = SPKALTSET0;
    
    SPK_Power_On();
    
    USB[UPCON] |= CONEN;                         // Connecter to Host ( Enable the pull-up resistor )
  }


void USB_Rd_FIFO( BYTE *Buffer , BYTE Cnt )
  { BYTE i;
    
    
    for ( i=0 ; i<Cnt ; i++ )  
       Buffer[i] = USB[RXDAT];
  }


void USB_Wr_FIFO( BYTE *Buffer , BYTE Cnt )
  { BYTE i;
    
    
    for ( i=0 ; i<Cnt ; i++ )  
       USB[TXDAT] = Buffer[i];
  }


void USB_Ep0_FIFO( void )
  { BYTE BLen;
    
    
    USB[TXCON] = TXCLR;                          // Clear Tx FIFO
    
    if ( USB[RXSTAT] & ( STOVW | EDOVW ))        // Setup Token
      { Ep0.Stage = SETUPSTAGE;
        while(1)
          { while(USB[RXSTAT] & STOVW);          // waiting STOVE = 0
            while(!( USB[RXSTAT] & EDOVW ));     // waiting EDOVW = 1
            USB[RXSTAT] &= ~EDOVW;               // Clear the EDOVW bit when reading the contents of the FIFO
            USB[UIFLG] = URXD0;                  // Write "1" to Clear this Flag
            BLen = USB[RXCNT];                   // Chk total Rx Data count in Byte
            USB_Rd_FIFO( Ep0.RxTx , BLen );
            if (!(USB[RXSTAT] & ( STOVW | EDOVW )))
              break;
          }
        USB[EPCON] &= ~( RXSTL | TXSTL );        // Release Rx/Tx STAL
        USB[RXSTAT] &= ~RXSETUP;                 // Release Setup Token flag
        Ep0.All = BLen;                          // Only for analytic "Urd"
      }
    else if ( Ep0.Stage == DATASTAGE )
      { BLen = USB[RXCNT];                       // Chk total Rx Data count in Byte  
      	Ep0.All -= BLen;
      	
      	USB_Rd_FIFO( Ep0.RxTx , BLen );
      	if ( BLen == EP0_MAX )
      	  { USB[TXCNT] = 0;
      	    Ep0.Stage = Ep0.RxTx[0];
      	  }
      	else if ( BLen == 1 )
      	  { LED_STATUS = Ep0.RxTx[0];
      	    KB_LED_Status();
      	    USB[TXCNT] = 0;
            Ep0.Stage = STATUSSTAGE;
      	  }
      	else
      	  { USB[TXCNT] = 0;
            Ep0.Stage = STATUSSTAGE;
      	  }
      }
    else if ( Ep0.Stage == USBSPKSTAGE )
      { BLen = USB[RXCNT];                       // Chk total Rx Data count in Byte  
      	USB_Rd_FIFO( Ep0.RxTx , BLen );
        if ( Spk.CS == SPK_CS_MUTE )
          { if ( Ep0.RxTx[0] == 0x01 )
              { if ( Spk.IDS == ID_SPK_FU )
              	  { Spk.Vol_Mute = SET;
              	  
                    SPK_VOL_Vol_Ctrl( Spk.Silente , Spk.Silente );
                    
                    USB[AFCTL] |= ADO_ME;
                  }
                else if ( Spk.IDS == ID_MIC_FU )
                  { Spk.Mic_Mute = SET;
                    
                    SPK_VOL_Mic_Ctrl( Spk.Silente );
                    
                    USB[AFCTL] |= ADI_ME;
                  }
                else if ( Spk.IDS == ID_MIX_FU )
                  { Spk.Mix_Mute = SET;
                    
                    SPK_VOL_Mix_Ctrl( Spk.Silente );
                    
                    USB[AFCTL] &= ~MIXEN;
                  }
              }
            else
              { if ( Spk.IDS == ID_SPK_FU )
              	  { Spk.Vol_Mute = CLR;
              	    
              	    USB[AFCTL] &= ~ADO_ME;
              	    
                    SPK_VOL_Vol_Ctrl( Spk.LCurVol , Spk.RCurVol );
                  }
                else if ( Spk.IDS == ID_MIC_FU )
                  { Spk.Mic_Mute = CLR;
                    
                    USB[AFCTL] &= ~ADI_ME;
                    
                    SPK_VOL_Mic_Ctrl( Spk.Mic_Cur );
                  }
                else if ( Spk.IDS == ID_MIX_FU )
                  { Spk.Mix_Mute = CLR;
                  
                    USB[AFCTL] |= MIXEN;
                    
                    SPK_VOL_Mix_Ctrl( Spk.Mix_Cur );
                  }
              }
          }
        else if ( Spk.CS == SPK_CS_VOLUME )
          { if ( Spk.Channel == SPK_M_CHANNEL )
      	      { if ( Ep0.RxTx[1] == 0x80 )       // Silence
      	          { if ( Spk.IDS == ID_MIC_FU )
                      Spk.Mic_Cur = Spk.Silente;
                    else if ( Spk.IDS == ID_MIX_FU )
                      Spk.Mix_Cur = Spk.Silente;
                    else
                      { Spk.Vol_Cur = Spk.Silente;
      	                Spk.LCurVol = Spk.Silente;
                        Spk.RCurVol = Spk.Silente;
                      }
      	          }
      	        else
      	          { if ( Spk.IDS == ID_MIC_FU )
                      Spk.Mic_Cur = (signed char)(Ep0.RxTx[1]);
                    else if ( Spk.IDS == ID_MIX_FU )
                      Spk.Mix_Cur = (signed char)(Ep0.RxTx[1]);
                    else
                      { Spk.Vol_Cur = (signed char)(Ep0.RxTx[1]);
      	                Spk.LCurVol = (signed char)(Ep0.RxTx[1]);
                        Spk.RCurVol = (signed char)(Ep0.RxTx[1]);
                      }
      	          }
      	      }
      	    else                                 // Only for Speaker
      	      { if ( Ep0.RxTx[1] == 0x80 )       // Silence
                  { if ( Spk.Channel == SPK_L_CHANNEL )
      	              Spk.LCurVol = Spk.Silente;
      	            else
      	              Spk.RCurVol = Spk.Silente;
      	          }
                else
      	          { if ( Spk.Channel == SPK_L_CHANNEL )
      	              Spk.LCurVol = (signed char)(Ep0.RxTx[1]);
      	            else
      	              Spk.RCurVol = (signed char)(Ep0.RxTx[1]);
      	          }
      	      }
      	      
            if ( Spk.IDS == ID_SPK_FU )
              SPK_VOL_Vol_Ctrl( Spk.LCurVol , Spk.RCurVol );
            else if ( Spk.IDS == ID_MIC_FU )
              SPK_VOL_Mic_Ctrl( Spk.Mic_Cur );
            else if ( Spk.IDS == ID_MIX_FU )
              SPK_VOL_Mix_Ctrl( Spk.Mix_Cur );

            Spk.Channel = SPK_X_CHANNEL;         // Unknow Channel
          }
        else if ( Spk.CS == SPK_CS_BASS )
          { //Wm8987l_Bass( Ep0.RxTx[0] );
            Spk.Bas_Cur = Ep0.RxTx[0];
          }
      	else if ( Spk.CS == SPK_CS_TREBLE )
      	  { //Wm8987l_Treble( Ep0.RxTx[0] );
            Spk.Trb_Cur = Ep0.RxTx[0];
      	  }
        else if ( Spk.CS == SPK_CS_FEQ )         // 
          { 
          }
        
      	Ep0.All = 0;
        USB[TXCNT] = 0;
        Ep0.Stage = STATUSSTAGE;
      }
    else                                         // Zero Length Data in RXCNT
      { Ep0.Stage = STATUSSTAGE;
      	USB[EPCON] |= ( RXSTL | TXSTL );         // Receive the host "ACK" transaction , we should set Rx/Tx STAL
      }
    
    USB[RXCON] |= RXFFRC;                        // Set this bit , meaning that Rx Data has Read Complete
  }
  

void USB_Get_Status( void )
  { Ep0.All = 2;                                 // Only 2 byte transfer to the host
    
    
    Ep0.RxTx[1] = 0;
    switch( Ep0.RxTx[0] & 0x03 )                 // Request Type ( Reserve low 2 bit )
      { case DEVICEREQUEST:    if ( Ep0.RWEN )
                                 Ep0.RxTx[0] = 0x02;// Return Function Remove Wake-up Enable
                               else
                                 Ep0.RxTx[0] = 0x00;// Return Function Remove Wake-up Disable
#ifdef SELF_POWER                                // Report Self Power
                               Ep0.RxTx[0] |= 0x01;
#endif
                               break;            // Chk Remote wakeup enabled or not
        case ENDPOINTREQUEST:  USB[EPINDEX] = Ep0.RxTx[4] & 0x0F;
                               if (( USB[EPCON] & RXSTL )||( USB[EPCON] & TXSTL ))
                                 Ep0.RxTx[0] = 0x01;// if EndPoint Rx/Tx STAL then set EndPoint Halt
                               else
                                 Ep0.RxTx[0] = 0x00;// else seting this EndPoint Avaliable for Rx/Tx  
                               USB[EPINDEX] = EP0;
                               break;
        case INTERFACEREQUEST: break;
        default:               USB[EPCON] |= ( RXSTL | TXSTL );
                               break; 
      }
  }  	


void USB_Clear_Feature( void )
  { switch( Ep0.RxTx[0] & 0x03 )                 // Request Type ( Reserve low 2 bit )
      { case DEVICEREQUEST:    if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                                 Ep0.RWEN = CLR;
                               else
                                 USB[EPCON] |= ( RXSTL | TXSTL );
                               break;            // Disable the Device Remote Wakeup function
        case ENDPOINTREQUEST:  if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                                 { USB[EPINDEX] = Ep0.RxTx[4] & 0x0F;
                                   USB[EPCON] &= ~( RXSTL | TXSTL );
                                   USB[RXSTAT] = RXSOVW;// Enable RXSEQ/TXSEQ bit can be Updata , and
                                   USB[TXSTAT] = TXSOVW;// set Rx/Tx toggle buffer into DATA0
                                   USB[EPINDEX] = EP0;
                                 }
                               else
                                 USB[EPCON] |= ( RXSTL | TXSTL );
                               break;
        case INTERFACEREQUEST: break;
        default:               USB[EPCON] |= ( RXSTL | TXSTL );
                               break;
      }
  }
 
  
void USB_Set_Feature( void )
  { switch( Ep0.RxTx[0] & 0x03 )                 // Request Type ( Reserve low 2 bit )
      { case DEVICEREQUEST:    if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                                 Ep0.RWEN = SET;
                               else
                                 USB[EPCON] |= ( RXSTL | TXSTL );
                               break;            // Disable the Device Remote Wakeup function
        case ENDPOINTREQUEST:  if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                                 { USB[EPINDEX] = Ep0.RxTx[4] & 0x0F;
                                   USB[EPCON] |= ( RXSTL | TXSTL );
                                   USB[EPINDEX] = EP0;
                                 }
                               else
                                 USB[EPCON] |= ( RXSTL | TXSTL );
                               break;
        case INTERFACEREQUEST: break;
        default:               USB[EPCON] |= ( RXSTL | TXSTL );
                               break; 
      }
  }  


void USB_Get_Descriptor( void )
  { union WTYPE WLen;
    
    
    WLen.B[0] = 0x00;                            // MSB
    Ep0.All = Ep0.RxTx[7];                       // MSB
    Ep0.All <<= 8;
    Ep0.All += Ep0.RxTx[6];                      // LSB
    switch( Ep0.RxTx[3] )	
      { case DEVICEDESCRIPTOR:        Ep0.Buf = DEVICE_DESCRIPTOR;
                                      WLen.B[1] = Ep0.Buf[0];
                                      break;
        case CONFIGURATIONDESCRIPTOR: Ep0.Buf = CONGFIGURATION_DESCRIPTOR;
                                      WLen.B[1] = Ep0.Buf[2];// LSB
                                      WLen.B[0] = Ep0.Buf[3];// MSB
                                      break;
        case STRINGDESCRIPTOR:        switch( Ep0.RxTx[2] )
                                        { case 0:  Ep0.Buf = LANGUAGEID_DESCRIPTOR;
                                                   break;
                                          case 1:  if ( DEVICE_DESCRIPTOR[14] )
                                                     Ep0.Buf = MANUFACTURER_DESCRIPTOR;
                                                   else
                                                     USB[EPCON] |= ( RXSTL | TXSTL );
                                                   break;
                                          case 2:  if ( DEVICE_DESCRIPTOR[15] )
                                                     Ep0.Buf = PRODUCT_DESCRIPTOR;
                                                   else
                                                     USB[EPCON] |= ( RXSTL | TXSTL );
                                                   break;
                                          case 3:  if ( DEVICE_DESCRIPTOR[16] )
                                                     Ep0.Buf = SERIALNUMBER_DESCRIPTOR;
                                                   else
                                                     USB[EPCON] |= ( RXSTL | TXSTL );
                                                   break;
                                          default: USB[EPCON] |= ( RXSTL | TXSTL );
                                                   break;
                                        }
                                      WLen.B[1] = Ep0.Buf[0];
                                      break;
        case HIDDESCRIPTOR:           if ( Ep0.RxTx[4] )
                                        { Ep0.Buf = MS_HID_DESCRIPTOR;
                                          WLen.B[1] = Ep0.Buf[0];
                                        }
                                      else
                                        { Ep0.Buf = KB_HID_DESCRIPTOR;
                                          WLen.B[1] = Ep0.Buf[0];
                                        }
                                      break;
      	case HIDREPORT:               if ( Ep0.RxTx[4] )
      	                                { Ep0.Buf = MS_HID_REPORT;
      	                                  WLen.B[1] = MS_HID_DESCRIPTOR[7];
      	                                  WLen.B[0] = MS_HID_DESCRIPTOR[8];
      	                                }
      	                              else
      	                                { Ep0.Buf = KB_HID_REPORT;
      	                                  WLen.B[1] = KB_HID_DESCRIPTOR[7];
      	                                  WLen.B[0] = KB_HID_DESCRIPTOR[8];
      	                                }
      	                              break;
      	default:                      USB[EPCON] |= ( RXSTL | TXSTL );
                                      break;
      }
    
    if ( Ep0.All > WLen.W )
      Ep0.All = WLen.W;
    
  }


void USB_Set_Configuration( void )
  { BYTE i;
    
    
    Ep0.Tmp = Ep0.RxTx[2];
    if ( Ep0.Tmp )
      { 
#ifdef PM_LBP      	
      	for ( i=1 ; i<3 ; i++ )
#endif
#ifdef PM_DTP
      	for ( i=1 ; i<6 ; i++ )
#endif
           { USB[EPINDEX] = i;
             USB[EPCON] = ( TXEPEN | RXEPEN );   // Enable Receive Input/Transmit Output
             USB[RXCON] = RXCLR;                 // Clear Rx FIFO
             USB[TXCON] = TXCLR;                 // Clear Tx FIFO
             USB[RXSTAT] = RXSOVW;               // Enable RXSEQ/TXSEQ bit can be Updata , and
             USB[TXSTAT] = TXSOVW;               // set Rx/Tx toggle buffer into DATA0
           }
        
        USB[GS_LCO] = 0x12;                      // -10dB
        USB[GS_RCO] = 0x12;
        USB[GS_ADI] = 0x12;
        USB[GS_MIX] = 0x12;
        
        Spk.Vol_Max = 0x17;                      // 0dB
        Spk.Vol_Min = 0x01;                      // -48dB
        Spk.Silente = 0x00;                      // -54dB
        Spk.Vol_Cur = 0x12;                      // -10dB
        
        Spk.Mic_Max = 0x17;
        Spk.Mic_Cur = 0x12;
        
        Spk.Mix_Max = 0x17;
        Spk.Mix_Cur = 0x12;
        
        Spk.Bas_Cur = 0;                         // Current Bass(0x00)
        Spk.Bas_Max = 15;                        // (0x0F)
        Spk.Bas_Min = 0;                         // 
        Spk.Trb_Cur = 0;                         // Current Treble(0x00)
        Spk.Trb_Max = 15;                        // (0x0C)
        Spk.Trb_Min = 0;                         //
        
        Spk.LCurVol = Spk.Vol_Cur;
        Spk.RCurVol = Spk.Vol_Cur;
        Spk.Channel = SPK_X_CHANNEL;             // Unknow Channel
    
        Spk.Tmp = 0xFF;                          // Initial for Volume Index
        
        USB[AFCTL] |=  SIFEN;                    // Enable Serial Interface
        
//        SPK_Initial_Codec();
        
        Ep0.EmuOk = SET;                         // Emulation Flow pass
      }
    else                                         // Set EP1,2,3,4 into Address state
      { for ( i=1 ; i<6 ; i++ )
           { USB[EPINDEX] = i;
             USB[EPCON] = 0x00;
           }
        
        Ep0.Out_AltSet = SPKALTSET0;
        
        USB[AFCTL] &= ~SIFEN;                    // Disable Serial Interface
      
      }
    USB[EPINDEX] = EP0;
  }


void USB_Set_Interface( void )
  { switch( Ep0.RxTx[4] )
      { case 0:                                  // For Interface0 ( HID )
        case 4:
        case 1:  if ( Ep0.RxTx[2] > 0 )          // For Interface1 ( Audio Control )
                   USB[EPCON] |= ( RXSTL | TXSTL );
                 else
                   USB[TXCNT] = 0;
                 break;
        case 2:  if ( Ep0.RxTx[2] > 1 )          // Audio Out
                   USB[EPCON] |= ( RXSTL | TXSTL );
                 else  
                   { Ep0.Out_AltSet = Ep0.RxTx[2];
                     USB[TXCNT] = 0;
                   }
                 break;
        case 3:  if ( Ep0.RxTx[2] > 1 )          // Audio In
                   USB[EPCON] |= ( RXSTL | TXSTL );
                 else  
                   { Ep0.In_AltSet = Ep0.RxTx[2];
                     USB[TXCNT] = 0;
                   }
                 break;
        default: USB[EPCON] |= ( RXSTL | TXSTL );
                 break;
      }
  }


void USB_Get_Interface( void )
  { Ep0.All = 1;
    switch( Ep0.RxTx[4] )
      { case 0:                                  // For Interface0 ( HID )
        case 4:
        case 1:  Ep0.RxTx[0] = 0;                // For Interface1 ( Audio Control )
                 break;
        case 2:  Ep0.RxTx[0] = Ep0.Out_AltSet;
                 break;
        case 3:  Ep0.RxTx[0] = Ep0.In_AltSet;
                 break;
        default: USB[EPCON] |= ( RXSTL | TXSTL );
                 break;
      }
  }


void USB_CtrlRd( void )                          // Host In , USB Out ( Only for EP0 )
  { BYTE BLen;
    
    
    if ( Ep0.Stage == DATASTAGE )                // In DATASTAGE we should move Data to TXFIFO
      { if ( Ep0.All > Ep0.Unit )
          BLen = Ep0.Unit;
        else
          BLen = Ep0.All;
      	USB_Wr_FIFO( Ep0.Buf , BLen );
      	USB[TXCNT] = BLen;                       // Set this byte will Trigger USB to Transmit Data to the Host
        Ep0.All -= BLen;                         // Calculated the Remain Data size
        Ep0.Buf += BLen;                         // Move Buffer Address in Right position
      }
    else if ( Ep0.Stage == USBSPKSTAGE )
      { if ( Spk.CS == SPK_CS_MUTE )
          { if ( Spk.IDS == ID_SPK_FU )
              Ep0.RxTx[0] = Spk.Vol_Mute;
            else if ( Spk.IDS == ID_MIX_FU )
              Ep0.RxTx[0] = Spk.Mix_Mute;
            else if ( Spk.IDS == ID_MIC_FU )
              Ep0.RxTx[0] = Spk.Mic_Mute;
          }
        else if ( Spk.CS == SPK_CS_VOLUME )
          { Ep0.RxTx[0] = 0x00;// LSB
            if ( Ep0.RxTx[1] == GET_SPK_MAX )
              { if ( Spk.IDS == ID_MIC_FU )
                  Ep0.RxTx[1] = Spk.Mic_Max;
                else if ( Spk.IDS == ID_MIX_FU )
                  Ep0.RxTx[1] = Spk.Mix_Max;
                else if ( Spk.IDS == ID_SPK_FU )
                  Ep0.RxTx[1] = Spk.Vol_Max;
                else
                  { USB[EPCON] |= ( RXSTL | TXSTL );
                    return;
                  }
              }
            else if ( Ep0.RxTx[1] == GET_SPK_MIN )
              Ep0.RxTx[1] = Spk.Vol_Min;
            else if ( Ep0.RxTx[1] == GET_SPK_CUR )
              { if ( Spk.IDS == ID_MIC_FU )
                  Ep0.RxTx[1] = Spk.Mic_Cur;
                else if ( Spk.IDS == ID_MIX_FU )
                  Ep0.RxTx[1] = Spk.Mix_Cur;
                else if ( Spk.IDS == ID_SPK_FU )
                  Ep0.RxTx[1] = Spk.Vol_Cur;
                else
                  { USB[EPCON] |= ( RXSTL | TXSTL );
                    return;
                  }
              }
            else if ( Ep0.RxTx[1] == GET_SPK_RES )
              Ep0.RxTx[1] = 0x01;
          }
        else if ( Spk.CS == SPK_CS_BASS )
          { if ( Ep0.RxTx[1] == GET_SPK_MAX )
              Ep0.RxTx[0] = Spk.Bas_Max;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_MIN )
              Ep0.RxTx[0] = Spk.Bas_Min;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_CUR )
              Ep0.RxTx[0] = Spk.Bas_Cur;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_RES )
              Ep0.RxTx[0] = 0x01;// MSB
          }
        else if ( Spk.CS == SPK_CS_TREBLE )
          { if ( Ep0.RxTx[1] == GET_SPK_MAX )
              Ep0.RxTx[0] = Spk.Trb_Max;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_MIN )
              Ep0.RxTx[0] = Spk.Trb_Min;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_CUR )
              Ep0.RxTx[0] = Spk.Trb_Cur;// MSB
            else if ( Ep0.RxTx[1] == GET_SPK_RES )
              Ep0.RxTx[0] = 0x01;// MSB
          }
        else if (  Spk.CS == SPK_CS_UNDEFINED )
          { if ( Spk.IDS == ID_SU )
              Ep0.RxTx[0] = 0x01;
            else
              { USB[EPCON] |= ( RXSTL | TXSTL );
                return;
              }
          }
        else
          { USB[EPCON] |= ( RXSTL | TXSTL );
            return;
          }
        
        if ( Ep0.All > Ep0.Unit )
          BLen = Ep0.Unit;
        else
          BLen = Ep0.All;
      	USB_Wr_FIFO( Ep0.Buf , BLen );
      	USB[TXCNT] = BLen;                       // Set this byte will Trigger USB to Transmit Data to the Host
        Ep0.All -= BLen;                         // Calculated the Remain Data size
        Ep0.Buf += BLen;                         // Move Buffer Address in Right position
      }
    else
      { USB[EPCON] |= ( RXSTL | TXSTL );         // In STATUSSTAGE we should STAL Rx/Tx
        if ( Ep0.Stage == SETADDRESS )           // Different from other STATUSSTAGE(importent)
          { USB[UADDR] = Ep0.Tmp;                // Set Address
            SPK_PLL_Divider();
//            USB[SFMCTL] = ( Spk.HfCon | PLL_LOCK_USB );
            USB[SFMCTL] = 0x33;
          }
        if ( Ep0.Stage == DFU_RESET )
          { Reboot_Mcu( REBOOT_TO_ISP );
          }
      }
  }


void USB_Stardard_Request( void )
  { switch( Ep0.RxTx[1] )                        // Request Code
      { case GET_STATUS:        Ep0.Stage = DATASTAGE;
                                USB_Get_Status();
                                USB_CtrlRd();
                                break;
        case CLEAR_FRATURE:	Ep0.Stage = STATUSSTAGE;  
                                USB_Clear_Feature();
                                USB[TXCNT] = 0;  // USB will return ACK immediately when receive IN transaction
                                break;
        case SET_FEATURE:       Ep0.Stage = STATUSSTAGE;
                                USB_Set_Feature();
                                USB[TXCNT] = 0;  // USB will return ACK immediately when receive IN transaction  
                                break;
        case SET_ADDRESS:       Ep0.Stage = SETADDRESS;// Different from other STATUSSTAGE
                                Ep0.Tmp = Ep0.RxTx[2];
                                USB[TXCNT] = 0;  // USB will return ACK immediately when receive IN transaction  
                                break;
        case GET_DESCRIPTOR:    Ep0.Stage = DATASTAGE;
                                USB_Get_Descriptor();
                                USB_CtrlRd();
                                break;
//        case SET_DESCRIPTOR:    break;
        case GET_CONFIGURATION: Ep0.Stage = DATASTAGE;
                                Ep0.RxTx[0] = Ep0.Tmp;// This value get from SET_CONFIGURATION transaction
                                Ep0.All = 1;     // Only 1 byte transfer to the host
                                USB_CtrlRd();
                                break;
        case SET_CONFIGURATION: Ep0.Stage = STATUSSTAGE;
                                USB_Set_Configuration(); // Will store configuration value to Ep0.Tmp
                                USB[TXCNT] = 0;  // USB will return ACK immediately when receive IN transaction
                                break;
        case SET_INTERFACE:     Ep0.Stage = STATUSSTAGE;
                                USB_Set_Interface();
                                break;
        case GET_INTERFACE:     Ep0.Stage = DATASTAGE;
                                USB_Get_Interface();
                                USB_CtrlRd();
                                break;
        case SYNCH_FRAME:       Ep0.Stage = STATUSSTAGE;
                                USB[TXCNT] = 0;  // USB will return ACK immediately when receive IN transaction
                                Ep0.All = 0;
                                break;
        default:                USB[EPCON] |= ( RXSTL | TXSTL );
                                break;           // Set Rx/Tx STAL 
      }
  }


void USB_Class_Request( void )
  { if ( Ep0.RxTx[0] & GET_REQUEST )             // Get Request
      { switch( Ep0.RxTx[1] )                    // Request Code
          { case GET_IDLE:     Ep0.Stage = DATASTAGE;
                               Ep0.RxTx[0] = KB.Key.IdleRate;
                               Ep0.All = 1;      // Only 1 byte transfer to the host
                               USB_CtrlRd();
                               break;
      	    case GET_REPORT:   Ep0.Stage = DATASTAGE;
                               Ep0.RxTx[0] = LED_STATUS;
                               Ep0.All = 1;      // Only 1 byte transfer to the host
                               USB_CtrlRd();
                               break;
            case GET_PROTOCOL: Ep0.Stage = DATASTAGE;
                               Ep0.RxTx[0] = KB.Key.Protocol;
                               Ep0.All = 1;      // Only 1 byte transfer to the host
                               USB_CtrlRd();
                               break;
      	    case GET_SPK_MAX:
            case GET_SPK_MIN:
            case GET_SPK_CUR:
            case GET_SPK_RES:  Ep0.Stage = USBSPKSTAGE;
                               Ep0.All = Ep0.RxTx[7];
                               Ep0.All <<= 8;
                               Ep0.All += Ep0.RxTx[6];
                               Spk.IDS = Ep0.RxTx[5];
                               Spk.CS = Ep0.RxTx[3];
                               USB_CtrlRd();
                               break;
      	    default:           USB[EPCON] |= ( RXSTL | TXSTL );
                               break;            // Set Rx/Tx STAL 
      	  }
      }
    else                                         // Set Request
      { switch( Ep0.RxTx[1] )                    // Request Code
          { case SET_IDLE:     Ep0.Stage = STATUSSTAGE;
                               KB.Key.IdleRate = Ep0.RxTx[3];
                               if ( Ep0.RxTx[4] == 4 ) // Mouse interface number
                                 Mouse.Act = SET;
                               else              // Keyboard
                                 KB.Act = SET;
                               USB[TXCNT] = 0;   // USB will return ACK immediately when receive IN transaction
                               break;
            case SET_REPORT:   Ep0.Stage = DATASTAGE;
                               Ep0.All = Ep0.RxTx[7];
                               Ep0.All <<= 8;
                               Ep0.All += Ep0.RxTx[6];
                               break;
            case SET_PROTOCOL: Ep0.Stage = STATUSSTAGE;
                               KB.Key.Protocol = Ep0.RxTx[2];
                               USB[TXCNT] = 0;   // USB will return ACK immediately when receive IN transaction
                               break;
            case SET_SPK_CUR:  if ( Ep0.RxTx[0] == SET_SPK_VOL )
                                 { Ep0.Stage = USBSPKSTAGE;
                                   Spk.IDS = Ep0.RxTx[5];
                                   Spk.CS = Ep0.RxTx[3];
                                   if ( Spk.CS == SPK_CS_VOLUME )
                                     Spk.Channel = Ep0.RxTx[2];
                                 }
                               else if ( Ep0.RxTx[0] == SET_FEQ_CTL )
                                 { Ep0.Stage = USBSPKSTAGE;
                                   Spk.CS = SPK_CS_FEQ;
                                 }
                               break;
            default:           USB[EPCON] |= ( RXSTL | TXSTL );
                               break;            // Set Rx/Tx STAL 
          }
      }
  }


void USB_CtrlWr( void )                          // Host Out , USB In ( Only for EPO )
  { Ep0.Buf = Ep0.RxTx;                          // Move Buffer address to RxTx[8] array , Use for USB_CtrlRd();
    USB_Ep0_FIFO();                              // Move Rx Data to RxTxBuf buffer
    if ( Ep0.Stage == SETUPSTAGE )               // if Setup Transection will set Ep0.All = 8
      {	Ep0.All = 0;
        switch( Ep0.RxTx[0] & 0x60 )             // Request Type
          { case STANDARD_REQUEST: USB_Stardard_Request();
                                   break;
            case CLASS_REQUEST:    USB_Class_Request();
                                   break;
            default:               USB[EPCON] |= ( RXSTL | TXSTL );
                                   break;       // Set Rx/Tx STAL 
          }
      }    
  }


void USB_Set_TxStatus( BYTE Flag )
  { BYTE Status;
    
    
    Status = USB[TXCON];
    Status &= 0x0F;                              // Reserve Low nibble
    Status |= Flag;
    USB[TXCON] = Status;                         // Clear Tx FIFO
  }


void USB_Int( void )
  { BYTE Status;
  
    
    Status = USB[UPCON];                         // Status in Power Control Register
    
    if ( Status & 0x0F )                         // Into Power Control mode
      { if ( Status & USUS )                     // Suspend mode
          { Status &= 0xF0;
            USB[UPCON] = ( Status | USUS );      // Write "1" to Clear this Flag
            
            Status = USB[UPCON];                 // Status in Power Control Register
            if (( Status & 0x0F ) == 0x00 )      // Into Power Control mode
              { KB_LED_Off();                    // Set all LED Off
                
                if ( Ep0.EmuOk == SET )
                  SPK_Power_Off();
                
              	if ( Ep0.RWEN == SET )
              	  { KB_WakeUp_State();
                    
                    KBPATN = 0xFF;
                    KBCON = 0x00;
                    KBMASK = 0xFF;
                  }
              
              	PCON |= 0x02;                    // Set CPU(8051) into PowerDown mode
              	
              	if ( Ep0.RWEN == SET )
      	          { KB_Normal_State();           // Release " P2.0/P2.1 " for IIC
      	          }
      	        
      	        if ( Ep0.EmuOk == SET )          // Set USB LED ON after " SET_CONFIGURATION "
      	          { KB_LED_Status();             // Restore LED status
      	            
      	            Delay_Xms( 1 );              // Wait MCLK Ready
      	            SPK_Power_On();
      	          }
              }
          }    
      	else
      	  { if ( Status & URST )                 // Reset mode
              {	Status &= 0xF0;
                USB[UPCON] = ( Status | URST );  // Write "1" to Clear this Flag
                Initial_KB();
                Initial_MS();
                Initial_USB();
              }
            else if ( Status & URSM )            // Resume mode  
              { Status &= 0xF0;
                USB[UPCON] = ( Status | URSM );  // Write "1" to Clear this Flag
              }
          }
      }
    else  
      { Status = USB[UIFLG];
        if ( Status & UTXD1 )                    // EP1 Transmit
          { USB[UIFLG] = UTXD1;                  // Write "1" to Clear this Flag
            USB[EPINDEX] = EP1;
            USB_Set_TxStatus( TXFFRC );
            if ( KB.Key.Busy == SET )
              KB.Key.Busy = CLR;
          }
        else if ( Status & UTXD2 )               // EP2 Transmit
          { USB[UIFLG] = UTXD2;                  // Write "1" to Clear this Flag
            USB[EPINDEX] = EP2;
            USB_Set_TxStatus( TXFFRC );
            if ( Mouse.Busy == SET )
              Mouse.Busy = CLR;
          }
        else if ( Status & URXD0 )               // EP0 Receive
          { USB[UIFLG] = URXD0;                  // Write "1" to Clear this Flag
            USB[EPINDEX] = EP0;
            USB_CtrlWr();                        // USB Standard Device Request(maybe)
          }
        else if ( Status & UTXD0 )               // EP0 Transmit
          { USB[UIFLG] = UTXD0;                  // Write "1" to Clear this Flag
            USB[EPINDEX] = EP0;
            USB_CtrlRd();
          }
        else if ( Status & SOFIF )
          { USB[UIFLG] = SOFIF;
            if ( Mouse.TimeOut )
              { Mouse.TimeOut--;
                if ( Mouse.TimeOut == 0 )
                  USB[UIE] &= ~SOFIE;            // Disable SOF interrupt
              }
          }
      }
  }